/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.util.StringTokenizer;

public final class Animation {
    public int m_fps = 20;
    public Color m_background = Color.black;
    public AnimationEvent m_head = null;
    public AnimationEvent m_tail;
    public Dimension m_size = new Dimension();

    public void addEvent(AnimationEvent animationEvent) {
        if (this.m_head == null) {
            this.m_head = animationEvent;
            this.m_tail = animationEvent;
        } else {
            this.m_tail.m_next = animationEvent;
            animationEvent.m_prev = this.m_tail;
            this.m_tail = animationEvent;
        }
    }

    public void drawFrame(Image image) {
        Graphics graphics = image.getGraphics();
        graphics.setColor(this.m_background);
        graphics.fillRect(0, 0, this.m_size.width, this.m_size.height);
        AnimationEvent animationEvent = this.m_head;
        while (animationEvent != null) {
            animationEvent.drawFrame(graphics);
            animationEvent = animationEvent.m_next;
        }
        graphics.dispose();
    }

    public void initFromParams(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            int n = string2.indexOf(58);
            if (n == -1) continue;
            String string3 = string2.substring(0, n).toUpperCase();
            String string4 = string2.substring(n + 1);
            if (string3.equals("FPS")) {
                this.m_fps = Integer.valueOf(string4);
                continue;
            }
            if (!string3.equals("BACKGROUND")) continue;
            this.m_background = Misc.initColour(string4);
        }
    }

    public void setSize(Rectangle rectangle) {
        this.m_size.width = rectangle.width;
        this.m_size.height = rectangle.height;
    }

    public String getUrl(int n, int n2) {
        AnimationEvent animationEvent = this.m_tail;
        while (animationEvent != null) {
            String string = animationEvent.getUrl(n, n2);
            if (string != null) {
                return string;
            }
            animationEvent = animationEvent.m_prev;
        }
        return null;
    }

    public void incFrame() {
        AnimationEvent animationEvent = this.m_head;
        while (animationEvent != null) {
            animationEvent.incFrame();
            animationEvent = animationEvent.m_next;
        }
    }
}

